/*********************************************************************
 *
 * Copyright:
 *	1999-2000 MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/
/*
 * File:	mcf5282_lo.s
 * Purpose:	Lowest level routines for the MCF5282.
 *
 * Notes:	
 */

#ifdef _UNDERSCORE_
#define exception_handler	_exception_handler
#define mcf5282_init		_mcf5282_init
#define main				_main
#endif
 
	.extern ___IPSBAR
	.extern ___SRAM
	.extern ___FLASH
	.extern ___SP_INIT
	.extern ___SRAM_SIZE
	.extern VECTOR_TABLE
	.extern exception_handler
	.extern mcf5xxx_wr_rambar0
	.extern mcf5xxx_wr_rambar1
	.extern mcf5282_init
	.extern main

	.global asm_startmeup
	.global _asm_startmeup
	.global	asm_exception_handler
	.global	_asm_exception_handler
	.global cpu_cache_flush
	.global _cpu_cache_flush
	.global	mcf5xxx_wr_cacr
	.global _mcf5xxx_wr_cacr
	.global	mcf5xxx_wr_vbr
	.global	_mcf5xxx_wr_vbr

	// add these definitions to make the original names bisible when debug, lvke Motorola 08/27/2004
	.function "asm_startmeup",_asm_startmeup,_asm_startmeup_end-_asm_startmeup
	.function "asm_exception_handler",_asm_exception_handler,_asm_exception_handler_end-_asm_exception_handler
	.function "cpu_cache_flush",_cpu_cache_flush,_cpu_cache_flush_end-_cpu_cache_flush
	.function "mcf5xxx_wr_cacr",_mcf5xxx_wr_cacr,_mcf5xxx_wr_cacr_end-_mcf5xxx_wr_cacr
	.function "mcf5xxx_wr_vbr",_mcf5xxx_wr_vbr,_mcf5xxx_wr_vbr_end-_mcf5xxx_wr_vbr
	// end comment, lvke Motorola 08/27/2004
	.text

/********************************************************************
 * This is the main entry point upon hard reset.
 */
asm_startmeup:
_asm_startmeup:

	move.w	#0x2700,sr

	/* Initialize IPSBAR */
	move.l	#(___IPSBAR + 1),d0
	move.l	d0,0x40000000
	
	/* Initialize FLASHBAR: locate internal Flash and validate it */
	/* Initialize RAMBAR0: This is the FLASHBAR */
	/** this sets bit 6 of the FLASHBAR.  Bit 6 is not documented, however,
	***	Motorola states that it is a workaround for the FLASH speculative
	*** read issues. See Errata data for the PCF5282, mask 0L95M. ***/ 
	move.l	#(___FLASH + 0x161),d0
    movec d0,RAMBAR0

	/* Initialize RAMBAR1: locate SRAM and validate it */
	move.l	#(___SRAM + 0x21),d0
    movec d0,RAMBAR1

	/* Point Stack Pointer into SRAM temporarily */
	move.l	#(___SRAM + 0x10000),sp

	/* Initialize mcf5282 periphs, etc */
	jsr		mcf5282_init

	/* Relocate Stack Pointer */ 
	move.l	#___SP_INIT,sp

	/* Jump to the main process */
	jmp		main
	
	bra		.
	nop
	nop
	halt
_asm_startmeup_end:

/********************************************************************
/*
 * This routine is the lowest-level exception handler.
 */
asm_exception_handler:
_asm_exception_handler:

	lea     -20(sp), sp
	movem.l d0-d2/a0-a1, (sp)
	pea.l   20(sp)              /* push exception frame address */
	jsr		exception_handler
	movem.l 4(sp), d0-d2/a0-a1
	lea     24(sp), sp
	rte
_asm_exception_handler_end:

/********************************************************************
 * The MCF5282 cache can be configured as instruction, data or split.
 * Invalidate the entire cache.
 */
cpu_cache_flush:
_cpu_cache_flush:
	nop						/* sync */
	move.l	#0x01000000,d0	/* Invalidate the I-Cache */
	movec 	d0,cacr
	rts
_cpu_cache_flush_end:
/********************************************************************/
/*
 * These routines write to the special purpose registers in the ColdFire
 * core.  Since these registers are write-only in the supervisor model,
 * no corresponding read routines exist.
 */
 
mcf5xxx_wr_cacr:
_mcf5xxx_wr_cacr:
    move.l  4(sp),d0
    movec d0,cacr	 
    nop
    rts
_mcf5xxx_wr_cacr_end:

mcf5xxx_wr_vbr:
_mcf5xxx_wr_vbr:
	move.l	4(sp),d0
	movec d0,VBR	
	nop
	rts
_mcf5xxx_wr_vbr_end:


	.end
